/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.aspect;

import java.util.Collection;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class LogAspect {
    private static final Logger a = LoggerFactory.getLogger(LogAspect.class);

    @Pointcut(value="execution(* com.tp_link.eap..*.service..*(..))")
    public void aspect() {
    }

    @AfterReturning(pointcut="aspect()", returning="rvt")
    public void afterReturning(JoinPoint joinPoint, Object rvt) {
        if (null != rvt) {
            a.trace("[after " + joinPoint + "];[args:" + this.a(joinPoint.getArgs()) + "];[return value]:" + this.a(rvt));
        }
    }

    private String a(Object ... objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (a.isDebugEnabled()) {
            if (objectArray.length == 0) {
                return "";
            }
            for (Object object : objectArray) {
                Object[] objectArray2;
                if (null == object) continue;
                if (object instanceof String || object instanceof Integer || object instanceof Long || object instanceof Boolean) {
                    stringBuffer.append("[" + object.toString() + "];");
                    continue;
                }
                if (object instanceof Collection) {
                    objectArray2 = (String[])object;
                    stringBuffer.append("length of collection is :" + objectArray2.size() + ";");
                    continue;
                }
                if (object instanceof String[]) {
                    objectArray2 = (String[])object;
                    stringBuffer.append("length of array is :" + objectArray2.length + ", they are :");
                    for (Object object2 : objectArray2) {
                        stringBuffer.append((String)object2 + ",");
                    }
                    stringBuffer.append(";");
                    continue;
                }
                if (object instanceof Integer[]) {
                    objectArray2 = (Integer[])object;
                    stringBuffer.append("length of array is :" + objectArray2.length + ", they are :");
                    for (Object object2 : objectArray2) {
                        stringBuffer.append(object2 + ",");
                    }
                    stringBuffer.append(";");
                    continue;
                }
                if (object instanceof Long[]) {
                    objectArray2 = (Long[])object;
                    stringBuffer.append("length of array is :" + objectArray2.length + ", they are :");
                    for (Object object2 : objectArray2) {
                        stringBuffer.append(object2 + ",");
                    }
                    stringBuffer.append(";");
                    continue;
                }
                stringBuffer.append(object.getClass());
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public Object around(JoinPoint joinPoint) {
        long l2 = System.currentTimeMillis();
        Object object = new Object();
        try {
            object = ((ProceedingJoinPoint)joinPoint).proceed();
            long l3 = System.currentTimeMillis();
            a.debug("[around " + joinPoint + "];[time elapsed: " + (l3 - l2) + " ms!]");
        }
        catch (Throwable throwable) {
            long l4 = System.currentTimeMillis();
            a.debug("[around " + joinPoint + "];[Use time : " + (l4 - l2) + " ms with exception : " + throwable.getMessage() + "]");
        }
        return object;
    }

    @AfterThrowing(pointcut="aspect()", throwing="ex")
    public void afterThrow(JoinPoint joinPoint, Exception ex) {
        a.warn("[Exception]" + joinPoint + "[exception message:" + ex.getMessage() + "]", (Throwable)ex);
    }
}

